/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.block;

import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.common.block.BaseHorizontalBlock;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.container.RepairStationContainer;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.tileentity.RepairStationTileEntity;
import dev.toma.gunsrpg.util.SkillUtil;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class RepairStationBlock
extends BaseHorizontalBlock {
    private static final ITextComponent TITLE = new TranslationTextComponent("container.repair_station");

    public RepairStationBlock(String name) {
        super(name, AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).harvestTool(ToolType.PICKAXE).func_200943_b(3.2f).func_226896_b_());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (!world.field_72995_K) {
            ISkillProvider provider = PlayerData.getUnsafe(player).getSkillProvider();
            if (provider.hasSkill(Skills.REPAIR_STATION)) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.func_220052_b(state, world, pos), (BlockPos)pos);
                return ActionResultType.SUCCESS;
            }
        } else {
            return ActionResultType.SUCCESS;
        }
        player.func_146105_b(SkillUtil.getMissingSkillText(Skills.REPAIR_STATION), true);
        return ActionResultType.CONSUME;
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World world, BlockPos pos) {
        RepairStationTileEntity tile = (RepairStationTileEntity)world.func_175625_s(pos);
        return new SimpleNamedContainerProvider((id, inv, ent) -> new RepairStationContainer(id, inv, tile), TITLE);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new RepairStationTileEntity();
    }
}

